*** Figure 7: Heterogeneity by County Characteristics – Political and Economic Forces

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 

*** OPEN MAIN COUNTY DTA 
use  "$data/main_county_FD.dta", clear

foreach t in 40 50 60 {
gen fr_black_40_y`t'=fr_black_40*y_`t'
gen cong_dem_40_y`t'=cong_dem_40*y_`t'
gen dem_40_y`t'=dem_40*y_`t'
}
.
egen cst=group(statefip county)
egen stateyear=group(statefip year)
egen regionyear=group(region year)

xtset cst year, delta(10)
global controls fr_black_40_y* dem_40_y*



foreach i in margin_any_40 manuf_sh_w sh_CIO_39 bartik_new {

gen `i'_M=0
sum `i' , d
replace `i'_M=1 if `i'>r(p50)
replace `i'_M=. if `i'==.

}
.
 

************************************************************************

cd "$output"


rename D_fr_black column1
foreach k in  1 0{
ivreg2 D_dummy_protest (column1=Z_p40)  i.stateyear $controls [aw=totpop_40]  ///
if manuf_sh_w_M==`k', cl(cst) ffirst
estimates store column1_`k'
}


rename column1 column2
foreach k in  1 0{
ivreg2 D_dummy_protest (column2=Z_p40)  i.stateyear $controls [aw=totpop_40]  ///
if sh_CIO_39_M==`k', cl(cst) ffirst
estimates store column2_`k'
}



rename column2 column3
foreach k in  1 0{
ivreg2 D_dummy_protest (column3=Z_p40)  i.stateyear $controls [aw=totpop_40] ///
if margin_any_40_M==`k', cl(cst) ffirst
estimates store column3_`k'
}



rename column3 column4

foreach k in  1 0{
ivreg2 D_dummy_protest (column4=Z_p40)  i.stateyear $controls [aw=totpop_40]  ///
if bartik_new_M==`k', cl(cst) ffirst
estimates store column4_`k'
}



coefplot ///
(column1_1 column2_1 column3_0 column4_1, label(Above Median)) ///
(column1_0 column2_0 column3_1 column4_0, label(Below Median) ///
msymbol(S)), ///
vertical recast(bar) yline(0, lcolo(black)) ciopts(recast(rcap) lcolor(cranberry)) citop barwidt(0.3) /// 
keep (column1 column2 column3 column4) ///
coeflabels( ///
column1="Share in manufacturing" ///
column2="Share workers in CIO" ///
column3="Political competition" ///
column4= "Predicted economic growth", ///
labsize(small) wrap(17))  ytitle("2SLS Coefficient on change in Black share",width(10)) p1(fcolor(gs2) lcolor(gs2)) p2(fcolor(gs11) lcolor(gs11)) graphregion(fcolor(white) ilcolor(white) lcolor(white)) ///
ylabel (,nogrid) xla(, notick) 

graph export "$output/Figure7.eps", replace 
 
 